<?php
/**
* @package XenCentral Ad Server
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @revision 97
* @version 2.0.0 beta 3 rev. 3
*/

class XenCentral_AdServer_Locations_CustomHook extends XenCentral_AdServer_Locations_Hooks_Abstract
{
    protected $location_id='custom_hook_name';

    protected $hook_name='custom_hook';

    /**
     * @return String
     * Returns unique string identified for the location
     */
    public function getLocationId()
    {
        return $this->location_id;
    }

    public function setLocationid($location_id)
    {
        $this->location_id=$location_id;
    }

    /**
     * @return String|XenForo_Phrase
     * Title for the location to be used in Admin Panel
     */
    public function getTitle()
    {
        return new XenForo_Phrase('xcas_custom_hook_name');
    }

    /**
     * @return String|XenForo_Phrase
     * Name of group for locations. Will be used to create tabs in Zone Manager
     */
    public function getGroup()
    {
        return new XenForo_Phrase('xcas_custom_hook');
    }

    /**
     * @return String|XenForo_Phrase
     * Name of sub-group for locations. Will be used to fieldsets in tabs
     */
    public function getSubGroup()
    {
        return '';
    }

    /**
     * @return String
     * Each location type should set its template name to be used to render location in Admin Panel
     */
    public function getOptionTemplate()
    {
        return 'xcas_custom_location_hook';
    }

    /**
     * @return String
     * Return name of hook for the location where it is executed
     */
    public function getHookName()
    {
        return $this->hook_name;
    }

    public function setHookName($hook_name)
    {
        $this->hook_name=$hook_name;
    }

    public function prepareFromData($locationData)
    {
        $locationData=parent::prepareFromData($locationData);

        if(empty($locationData['hooks'])) {
            $locationData['hooks']=array();
        }

        foreach($locationData['hooks'] AS $index=>$hookData) {
            if(!$hookData['hook_name']) {
                unset($locationData['hooks'][$index]);
            }
        }

        $locationData['hooks']=array_merge($locationData['hooks'], array()); // reset keys

        $locationData['hooks']['9999999']=array(
            'hook_name'=>'',
            'modification_type'=>'',
            'wrapper_template'=>'',
        );

        return $locationData;
    }

    public function getDescription()
    {
        return new XenForo_Phrase('xcas_custom_hook_name_explain');
    }

    /**
     * @param string $wrapper
     */
    public function setWrapper($wrapper)
    {
        $this->wrapper = $wrapper;
    }
}